
// VOIP Awesome Click-and-Dial Extension for Google Chrome
// Background Script
//
//  Copyright:  VOIP Awesome Inc, 2021
//  Author:     Jambu Atchison
//  @ Support:  cs@voipawesome.com
//



// Global Variables
if (typeof CND == 'undefined') { var CND = {}; }
if (typeof CND.background == 'undefined') { CND.background = {}; }
CND.online = true; // default true
if (typeof window != "undefined") {
    CND.online = window.navigator.onLine; // if we have a window, check if we're online
}
CND.jQuerySrc = "assets/jquery-2.1.1.js";
CND.background.accountRequiredNotification = false;
CND.background.bgChatsLists = {};
CND.background.bgChatsLists.ChatsLastLoaded = 0;
CND.background.bgChatsLists.ChatsListLoaded = {};
CND.background.bgChatsLists.ChatsLoaded = {};
CND.background.bgChatsLists.MessagesChatGroupId = 0;
CND.background.bgChatsLists.MessagesLastLoaded = 0;
CND.background.bgChatsLists.MessagesListLoaded = [];
CND.background.bgChatsLists.MessagesLoaded = [];
CND.background.bgChatsLists.LastRead = {};
CND.background.bgChatsLists.LastScroll = {};
CND.background.bgChatsLists.UnreadChats = {};
CND.background.bgChatsLists.NotifiedChats = {};
CND.background.bgChatsLists.Notifications = {};
CND.background.chatsLists = {};
CND.background.chatsListLocal = [];
CND.background.chatsListView = [];
CND.background.hasFocus = false;
CND.background.IntervalRefresh = 2000;
CND.background.IntervalRefreshTimeout = null;
CND.background.IntervalRefreshError = 10000;
CND.background.IntervalRefreshFast = 500;
CND.background.LastActive = 0;
CND.background.LastSearch = null;
CND.background.totalUnreadMsgs = 0;
CND.background.unixLast = 0;



// Global Functions
if (typeof CND.handleIsLoaded == 'undefined') {
    CND.handleIsLoadedWait = 1;
    CND.handleIsLoadedTimeout = null;
    CND.handleIsLoaded = function(fn='', successCallback=null, failureCallback=null, maxWait=10000, type='function') {
        if (!((typeof fn == 'string') && (fn !== ''))) { return; }
        if (CND.handleIsLoadedTimeout !== null) { clearTimeout(CND.handleIsLoadedTimeout); }
        CND.handleIsLoadedTimeout = setTimeout(function() {
            if (typeof fn == type) {
                if (typeof successCallback == 'function') { setTimeout(function() { successCallback(); }, 1); }
            } else if ((typeof fn == 'string') && (typeof CND != 'undefined') && (typeof CND[fn] == type)) {
                if (typeof successCallback == 'function') { setTimeout(function() { successCallback(); }, 1); }
            } else if (CND.handleIsLoadedWait < maxWait) {
                CND.handleIsLoadedWait = CND.handleIsLoadedWait + CND.handleIsLoadedWait * 3;
                CND.handleIsLoaded(fn, successCallback, failureCallback, maxWait);
            } else {
                if (typeof failureCallback == 'function') { setTimeout(function() { failureCallback(); }, 1); }
            } // end if fn
        }, CND.handleIsLoadedWait);
    }; // end function handleIsLoaded
} // end if handleIsLoaded


CND.background.handleInit = function(alertTimeout=1) {
    CND.date.myLocalTZ.name();

    //console.log("Ready");
    CND.getAccountInfo(function() {
        //console.log("Account Loaded", CND.accountSettings);
        //console.log('in chats.handleInit');
        CND.background.getChatsLocalLite(function() { CND.background.loadChatsList(); });
        //CND.background.IntervalRefreshTimeout = setInterval(function() { CND.background.loopCount++; console.log('Loop', CND.background.loopCount, CND.accountSettings); }, CND.background.IntervalRefresh);
    }, function() {
        setTimeout(function() {
            CND.background.alertAccountRequired();

            // Try again later
            clearTimeout(CND.background.loadChatsListTimeout);
            CND.background.loadChatsListTimeout = setTimeout(function() {
                CND.background.handleInit(1);
            }, CND.background.IntervalRefreshFast);

        }, alertTimeout);
    });
}; // end function CND.background.handleInit

CND.background.alertAccountRequired = function() {
    if (!CND.background.accountRequiredNotification) {
        var options = {
            title: 'A problem has occurred!',
            message: 'Please configure a valid account to use this extention',
            buttons : [{
                title: 'Set Up Now'
            }],
            requireInteraction: true
        };
        CND.createNotification(options, function(id) {
            CND.background.accountRequiredNotification = true;
            chrome.notifications.onClicked.removeListener(CND.background.notificationsClickChat);
            chrome.notifications.onButtonClicked.removeListener(CND.background.notificationsClickChat);
            chrome.notifications.onClicked.addListener(CND.background.loadPopupWindowSettings);
            chrome.notifications.onButtonClicked.addListener(CND.background.loadPopupWindowSettings);
        });
    } // end if CND.background.accountRequiredNotification
}; // end function CND.background.alertAccountRequired

CND.background.getChatsLocalLite = function(callbackFunction=null) {
    // Get information from the Cookies. Nom Nom
    chrome.storage.local.get([ 'chats_has_focus', 'chats_active_id', 'chats_search' ], function(items) {
        //console.log(items);
        CND.background.hasFocus = items.chats_has_focus ?? false;
        CND.background.LastActive = items.chats_active_id ?? -1;
        CND.background.LastSearch = items.chats_search ?? null;
        //console.log(items);
        if (typeof callbackFunction == 'function') {
            setTimeout(function() { callbackFunction(); }, 1);
        }
    }); // end chrome.storage.local.get
}; // end function CND.background.getChatsLocalLite


CND.background.getChatsLocal = function(callbackFunction=null) {
    // Get information from the Cookies. Nom Nom
    chrome.storage.local.get([ 'chats_has_focus', 'chats_active_id', 'chats_search', 'chats_lists' ], function(items) {
        //console.log(items);
        CND.background.hasFocus = items.chats_has_focus ?? false;
        CND.background.LastActive = items.chats_active_id ?? -1;
        CND.background.LastSearch = items.chats_search ?? null;
        CND.background.chatsLists = items.chats_lists ?? CND.background.chatsLists ?? {};
        if (typeof CND.background.chatsLists.ChatsLastLoaded == 'undefined') { CND.background.chatsLists.ChatsLastLoaded = 0; }
        if (typeof CND.background.chatsLists.ChatsListLoaded == 'undefined') { CND.background.chatsLists.ChatsListLoaded = {}; }
        if (typeof CND.background.chatsLists.ChatsLoaded == 'undefined') { CND.background.chatsLists.ChatsLoaded = {}; }
        if (typeof CND.background.chatsLists.MessagesChatGroupId == 'undefined') { CND.background.chatsLists.MessagesChatGroupId = 0; }
        if (typeof CND.background.chatsLists.MessagesLastLoaded == 'undefined') { CND.background.chatsLists.MessagesLastLoaded = 0; }
        if (typeof CND.background.chatsLists.MessagesListLoaded == 'undefined') { CND.background.chatsLists.MessagesListLoaded = []; }
        if (typeof CND.background.chatsLists.MessagesLoaded == 'undefined') { CND.background.chatsLists.MessagesLoaded = []; }
        if (typeof CND.background.chatsLists.LastRead == 'undefined') { CND.background.chatsLists.LastRead = {}; }
        if (typeof CND.background.chatsLists.LastScroll == 'undefined') { CND.background.chatsLists.LastScroll = {}; }
        if (typeof CND.background.chatsLists.UnreadChats == 'undefined') { CND.background.chatsLists.UnreadChats = {}; }
        if (typeof CND.background.chatsLists.NotifiedChats == 'undefined') { CND.background.chatsLists.NotifiedChats = {}; }
        if (typeof CND.background.chatsLists.Notifications == 'undefined') { CND.background.chatsLists.Notifications = {}; }
        //console.log(items);
        CND.background.getBackgroundChatsLocal(callbackFunction);
    }); // end chrome.storage.local.get
}; // end function CND.background.getChatsLocal


CND.background.getBackgroundChatsLocal = function(callbackFunction=null) {
    // Get information from the Cookies. Nom Nom
    chrome.storage.local.get([ 'chats_bg_active', 'chats_bg_lists' ], function(items) {
        //console.log('Memory:CND.background.bgChatsLists', CND.background.bgChatsLists ?? {});
        //console.log('Memory:NotifiedChats', CND.background.bgChatsLists.NotifiedChats ?? {});
        //console.log('Memory:LastActive', CND.background.LastActive ?? null);
        CND.background.bgLastActive = items.chats_bg_active ?? CND.background.LastActive ?? -1;
        //console.log('Storage:bgLastActive', CND.background.bgLastActive ?? null);
        CND.background.bgChatsLists = items.chats_bg_lists ?? CND.background.bgChatsLists ?? {};
        //console.log('Storage::CND.background.bgChatsLists', CND.background.bgChatsLists ?? {});
        if (typeof CND.background.bgChatsLists.ChatsLastLoaded == 'undefined') { CND.background.bgChatsLists.ChatsLastLoaded = 0; }
        if (typeof CND.background.bgChatsLists.ChatsListLoaded == 'undefined') { CND.background.bgChatsLists.ChatsListLoaded = {}; }
        if (typeof CND.background.bgChatsLists.ChatsLoaded == 'undefined') { CND.background.bgChatsLists.ChatsLoaded = {}; }
        if (typeof CND.background.bgChatsLists.MessagesChatGroupId == 'undefined') { CND.background.bgChatsLists.MessagesChatGroupId = 0; }
        if (typeof CND.background.bgChatsLists.MessagesLastLoaded == 'undefined') { CND.background.bgChatsLists.MessagesLastLoaded = 0; }
        if (typeof CND.background.bgChatsLists.MessagesListLoaded == 'undefined') { CND.background.bgChatsLists.MessagesListLoaded = []; }
        if (typeof CND.background.bgChatsLists.MessagesLoaded == 'undefined') { CND.background.bgChatsLists.MessagesLoaded = []; }
        if (typeof CND.background.bgChatsLists.LastRead == 'undefined') { CND.background.bgChatsLists.LastRead = {}; }
        if (typeof CND.background.bgChatsLists.LastScroll == 'undefined') { CND.background.bgChatsLists.LastScroll = {}; }
        if (typeof CND.background.bgChatsLists.UnreadChats == 'undefined') { CND.background.bgChatsLists.UnreadChats = {}; }
        if (typeof CND.background.bgChatsLists.NotifiedChats == 'undefined') { CND.background.bgChatsLists.NotifiedChats = {}; }
        if (typeof CND.background.bgChatsLists.Notifications == 'undefined') { CND.background.bgChatsLists.Notifications = {}; }
        //console.log('Storage Init:CND.background.bgChatsLists', CND.background.bgChatsLists ?? {});
        //console.log('Storage Init:NotifiedChats', CND.background.bgChatsLists.NotifiedChats ?? {});
        //console.log(items);
        if ((CND.background.bgLastActive != 0) && (CND.background.bgLastActive != CND.background.LastActive)) {
            CND.background.resetBackgroundChatsLocal(function() {
                //console.log('CND.background.LastActive', CND.background.LastActive ?? null);
                CND.background.bgLastActive = CND.background.LastActive;
                CND.background.bgChatsLists = CND.background.chatsLists;
                if (typeof callbackFunction == 'function') {
                    setTimeout(function() { callbackFunction(); }, 1);
                }
            });
            return;
        } else if ((CND.background.bgLastActive == CND.background.LastActive) && (CND.background.bgChatsLists.ChatsLastLoaded > CND.background.bgChatsLists.ChatsLastLoaded)) {
            //console.log('chats_loaded', CND.background.bgChatsLists.ChatsLastLoaded, CND.background.bgChatsLists.ChatsLastLoaded);
            CND.background.bgChatsLists = CND.background.chatsLists;
        } else {
            //console.log('chats_loaded', CND.background.bgChatsLists.ChatsLastLoaded, CND.background.bgChatsLists.ChatsLastLoaded);
            CND.background.chatsLists = CND.background.bgChatsLists;
        }
        if (typeof callbackFunction == 'function') {
            setTimeout(function() { callbackFunction(); }, 1);
        }
    }); // end set storage
}; // end function CND.background.getBackgroundChatsLocal


CND.background.resetBackgroundChatsLocal = function(callbackFunction=null) {
    //console.error('reset bg chats');
    CND.background.bgLastActive = 0;
    CND.background.bgChatsLists = {};
    CND.background.bgChatsLists.ChatsLastLoaded = 0;
    CND.background.bgChatsLists.ChatsListLoaded = {};
    CND.background.bgChatsLists.ChatsLoaded = {};
    CND.background.bgChatsLists.MessagesChatGroupId = 0;
    CND.background.bgChatsLists.MessagesLastLoaded = 0;
    CND.background.bgChatsLists.MessagesListLoaded = [];
    CND.background.bgChatsLists.MessagesLoaded = [];
    CND.background.bgChatsLists.LastRead = {};
    CND.background.bgChatsLists.LastScroll = {};
    CND.background.bgChatsLists.UnreadChats = {};
    CND.background.bgChatsLists.NotifiedChats = {};
    CND.background.bgChatsLists.Notifications = {};
    CND.background.saveBackgroundChatsLocal(CND.background.LastActive, CND.background.bgChatsLists, callbackFunction);
}; // end function CND.background.resetBackgroundChatsLocal


CND.background.saveBackgroundChatsLocal = function(a=0, l={}, callbackFunction=null) {
    // Set information from the Cookies. Nom Nom
    //console.log('Saving:NotifiedChats', l.NotifiedChats ?? {});
    if (typeof l.LastRead == 'undefined') {
        l = CND.background.bgChatsLists;
    } // end if l
    //console.error('Saving:bgLastActive', a ?? null);
    chrome.storage.local.set({ 'chats_bg_active' : a, 'chats_bg_lists' : l }, function() {
        //console.error('Saving:bgLastActive', a ?? null);
        CND.background.bgLastActive = a;
        CND.background.bgChatsLists = l;
        if (typeof callbackFunction == 'function') {
            setTimeout(function() { callbackFunction(); }, 1);
        } // end if callbackFunction
    }); // end set storage
}; // end function CND.background.saveBackgroundChatsLocal


CND.background.saveChatsLocal = function(a=0, callbackFunction=null) {
    // Set information from the Cookies. Nom Nom
    chrome.storage.local.set({ 'chats_active' : a }, function() {
        CND.background.LastActive = a;
        if (typeof callbackFunction == 'function') {
            setTimeout(function() { callbackFunction(); }, 1);
        } // end if callbackFunction
    }); // end set storage
}; // end function CND.background.saveChatsLocal


CND.background.handleSearchMsgs = function(callbackFunction=null) {
    var search = CND.background.LastSearch ?? '';
    search = search.toString().trim();
    if (search != '') {
        //console.log('search', search);
        CND.background.chatsListView = CND.getSearchResults(CND.background.bgChatsLists.ChatsListLoaded, search, true);
        CND.background.messagesListView = CND.getSearchResults(CND.background.bgChatsLists.MessagesListLoaded, search, true);
        //console.log('chats', CND.background.chatsListView);
        //console.log('msgs', CND.background.messagesListView);
        CND.background.LastSearch = search;
        setTimeout(function() {
            CND.background.updateChatsList(CND.background.chatsListView, function() {
                CND.background.updateMessagesList(CND.background.messagesListView, callbackFunction);
            });
        }, 1);
    } else {
        CND.background.LastSearch = '';
        //console.log('clear search');
        CND.background.chatsListView = CND.background.bgChatsLists.ChatsListLoaded;
        CND.background.messagesListView = CND.background.bgChatsLists.MessagesListLoaded;
        setTimeout(function() {
            CND.background.updateChatsList(CND.background.chatsListView, function() {
                CND.background.updateMessagesList(CND.background.messagesListView, callbackFunction);
            });
        }, 1);
    } // end if search
}; // end function CND.background.handleSearchMsgs


CND.background.loadChatsListTimeout = null;
CND.background.loadChatsList = function() {
    clearTimeout(CND.background.loadChatsListTimeout);
    if ((CND.background.LastActive != 0) && (CND.background.LastActive != CND.background.bgLastActive) && (CND.background.bgLastActive != 0)) {
        //console.log('lastActive', CND.background.LastActive, 'bgLastActive', CND.background.bgLastActive);
        CND.background.resetBackgroundChatsLocal(function() {
            //console.log('lastActive', CND.background.LastActive, 'bgLastActive', CND.background.bgLastActive);
            CND.background.bgLastActive = CND.background.LastActive;
            CND.background.getChatsLocalLite(function() { CND.background.loadChatsList(); });
        });
        return false;
    } // end if active
    var last = CND.background.unixLast ?? 0;
    var domain = CND.accountSettings.domain ?? CND.defaultSettings.domain ?? '';
    var apikey = CND.accountSettings.apikey ?? '';
    var search = CND.background.LastSearch ?? '';
    var chat_group_id = parseInt(CND.background.LastActive);
    var hasFocus = CND.background.hasFocus ?? false;
    var lastRead = CND.background.bgChatsLists.LastRead ?? {};
    //console.log('active', chat_group_id);
    //console.log('apikey', apikey);
    if (apikey != '') {
        var requestApiUrl = CND.getApiUrl(domain, true);
        var dataInputs = {
            'action': 'get_chats',
            'domain': domain,
            'key': apikey,
            'search': search,
            'active': chat_group_id,
            'hasFocus': hasFocus,
            'lastRead': lastRead,
            'last': last
        };
        CND.ajax({
            type: 'POST',
            dataType: 'json',
            url: requestApiUrl,
            data: dataInputs,
            error: function(xhr, error, message) {
                //console.log('error', requestApiUrl, xhr, error, message);
                if (typeof xhr.status != 'undefined') {
                    if (xhr.status == 403) { CND.loadPopupWindow(false, 'settings.html'); }
                }
                clearTimeout(CND.background.loadChatsListTimeout);
                CND.background.loadChatsListTimeout = setTimeout(function() {
                    CND.background.getChatsLocalLite(function() { CND.background.loadChatsList(); });
                }, CND.background.IntervalRefreshError);
            }, // end ajax error
            success: function(data) {
                //console.log('success', requestApiUrl, dataInputs, data);
                if ((data.status == true) || (data.status == 1)) {
                    //console.log(data);
                    //if (search != '') { console.log(data); }
                    var active = parseInt(data.active ?? 0);
                    CND.background.getChatsLocal(function() {
                        if ((CND.background.LastActive != 0) && (CND.background.LastActive != active) && (active != 0)) {
                            //console.log('lastActive', CND.background.LastActive, 'active', active);
                            CND.background.resetBackgroundChatsLocal(function() {
                                //console.log('bgLastActive', CND.background.bgLastActive, 'active', active);
                                CND.background.bgLastActive = active;
                                CND.background.getChatsLocalLite(function() { CND.background.loadChatsList(); });
                            });
                            return false;
                        } // end if active
                        var unread = data.unread ?? 0;
                        CND.background.unixLast = data.last ?? last;
                        var chats = data.chats ?? {};
                        var msgs = data.msgs ?? [];
                        CND.background.bgChatsLists.LastRead = data.lastRead ?? CND.background.bgChatsLists.LastRead ?? {};
                        CND.background.bgChatsLists.UnreadChats = data.unreadChats ?? CND.background.bgChatsLists.UnreadChats ?? {};
                        CND.background.bgChatsLists.ChatsListLoaded = chats;
                        CND.background.bgChatsLists.MessagesListLoaded = msgs;
                        //console.log('active', active, 'UnreadChats', CND.background.bgChatsLists.UnreadChats);
                        CND.background.saveBackgroundChatsLocal(active, CND.background.bgChatsLists, function() {
                            setTimeout(function() { CND.background.handleSearchMsgs(function() {
                                clearTimeout(CND.background.loadChatsListTimeout);
                                CND.background.loadChatsListTimeout = setTimeout(function() {
                                    //console.log('new loop');
                                    CND.background.getChatsLocalLite(function() { CND.background.loadChatsList(); });
                                }, CND.background.IntervalRefresh);
                            }); }, 1); // end setTimeout
                        }); // end CND.background.saveBackgroundChatsLocal
                    }); // end CND.background.getChatsLocalLite
                } else if (typeof data.error != 'undefined') {
                    clearTimeout(CND.background.loadChatsListTimeout);
                    CND.background.loadChatsListTimeout = setTimeout(function() {
                        CND.background.getChatsLocalLite(function() { CND.background.loadChatsList(); });
                    }, CND.background.IntervalRefreshError);
                } else {
                    clearTimeout(CND.background.loadChatsListTimeout);
                    CND.background.loadChatsListTimeout = setTimeout(function() {
                        CND.background.getChatsLocalLite(function() { CND.background.loadChatsList(); });
                    }, CND.background.IntervalRefreshError);
                } // end if data.status
            } // end ajax success
        }); // end ajax
    } else {
        clearTimeout(CND.background.loadChatsListTimeout);
        CND.background.loadChatsListTimeout = setTimeout(function() {
            CND.background.handleInit(1);
        }, CND.background.IntervalRefreshFast);
    } // end if apikey
    return true;
}; // end function CND.background.loadChatsList


CND.background.getContacts = function(contacts=[]) {
    var icl = 0, o = {
            'count' : 0,
            'text' : '[error]',
            'icon' : $('<i>').attr('class', 'fad fa-user-friends')
    };
    if (typeof contacts != 'undefined') {
        icl = contacts.length;
        //console.log(contacts);
        if (icl > 0) {
            for (ic = 0; ic < icl; ic++) {
                var tcontact = contacts[ic];
                if (ic > 0) { o.text += ', '; } else { o.text = ''; }
                if (tcontact.user_type == 'sms') {
                    o.text += CND.str.phoneNumber(tcontact.user, 'human');
                } else {
                    o.text += tcontact.user;
                } // end if user_type
                ++o.count;
            } // end foreach contacts
        } // end if icl
        if (icl > 1) {
            o.icon = $('<i>').attr('class', 'fad fa-users');
        } // end if icl
    } // end if contacts
    return o;
}; // end function CND.background.getContacts


CND.background.updateChatsList = function(chats={}, callbackFunction=null) {
    //console.log('chats', chats);
    if (typeof chats == 'undefined') { return; }
    if (typeof CND.background.LastActive == 'undefined') { CND.background.saveBackgroundChatsLocal(0, CND.background.bgChatsLists); }
    var first_id = 0, found_id = false, count = 0, added_new = 0, existing_chats = 0, notifications = 0, chats_last = 0;
    CND.background.totalUnreadMsgs = 0;
    for (var k in chats) {
        //console.log(chats[k]);
        //console.log($('#chat_list_item_tpl'));
        var tchat = chats[k];
        var chat_last = 0; // unix timestamp
        var chat_group_id = 0;
        var contacts_list = '[error]';
        var contacts_icon = $('<i>').attr('class', 'fad fa-user-friends');
        if (typeof tchat.chat_group_id != 'undefined') {
            chat_group_id = parseInt(tchat.chat_group_id);
        }
        if (typeof tchat.last != 'undefined') {
            chats_last = chat_last = tchat.last;
        } // end if last
        if (typeof tchat.unread == 'undefined') {
            tchat.unread = 0;
        } // end if unread
        if ((first_id == 0) && (chat_group_id != 0)) { first_id = chat_group_id; }
        if ((chat_group_id != 0) && (((CND.background.LastActive != 0) && (chat_group_id == CND.background.LastActive)) || ((CND.background.LastActive == 0) && (count == 0)))) {
            //console.log('Saving:chat_group_id', chat_group_id);
            found_id = true;
            CND.background.saveBackgroundChatsLocal(chat_group_id, CND.background.bgChatsLists);
        }
        var icl = 0, members_count = 0;
        if (typeof tchat.contacts != 'undefined') {
            var tcontacts = CND.background.getContacts(tchat.contacts);
            contacts_list = tcontacts.text ?? contacts_list;
            contacts_icon = tcontacts.icon ?? contacts_icon;
            members_count = tcontacts.count ?? members_count;
        } else { tchat.contacts = []; } // end if contacts
        if (CND.background.LastActive == chat_group_id) {
            var active_contacts_icon = contacts_icon.clone();
        } // end if CND.background.LastActive
        if (typeof tchat.preview != 'undefined') {
            if (tchat.preview != '') {
                var preview = tchat.preview.toString();
                preview = preview.substring(0, 14) + '...';
            } // end if preview
        } else { tchat.preview = ''; } // end if preview

        var chat_in_list = false, chat_in_list_last = 0;
        if (typeof CND.background.bgChatsLists.ChatsLoaded[chat_group_id] != 'undefined') {
            chat_in_list = true;
            chat_in_list_last = CND.background.bgChatsLists.ChatsLoaded[chat_group_id].last ?? 0;
        } // end if chat_in_list
        //console.log('chat_group_id', chat_group_id, 'chat_in_list', chat_in_list, 'chat_in_list_last', chat_in_list_last, 'chat_last', chat_last);

        if ((chat_group_id == CND.background.LastActive) && CND.background.hasFocus) {
            CND.background.bgChatsLists.LastRead[chat_group_id] = chat_last;
            if (typeof CND.background.bgChatsLists.UnreadChats[chat_group_id] != 'undefined') {
                delete CND.background.bgChatsLists.UnreadChats[chat_group_id];
            } // end if unread
        } else {
            chat_last_read = CND.background.bgChatsLists.LastRead[chat_group_id] ?? 0;
            if (chat_last > chat_last_read) {
                if (tchat.unread > 0) {
                    CND.background.totalUnreadMsgs += tchat.unread;
                    //console.log('Check:NotifiedChats', CND.background.bgChatsLists.NotifiedChats ?? {});
                    old_chat = CND.background.bgChatsLists.NotifiedChats[chat_group_id] ?? {};
                    //console.log('old_chat', old_chat);
                    old_last = old_chat.last ?? 0;
                    //console.log('old_last', old_last);
                    if ((old_last == 0) || (chat_last > old_last)) {
                        CND.background.bgChatsLists.UnreadChats[chat_group_id] = tchat;
                        ++notifications;
                    } else {
                        if (typeof CND.background.bgChatsLists.UnreadChats[chat_group_id] != 'undefined') {
                            delete CND.background.bgChatsLists.UnreadChats[chat_group_id];
                        } // end if unread
                    } // end if old_last
                } // end if tchat.unread
            } // end if chat_last_read
        } // end if CND.background.LastActive

        if (chat_in_list && chat_last > chat_in_list_last) {
            //console.log('chat_in_list', chat_in_list, 'chat_last', chat_last, 'chat_in_list_last', chat_in_list_last);
            //console.log('db', tchat);
            //console.log('lc', CND.background.bgChatsLists.ChatsLoaded[chat_group_id]);
            CND.background.bgChatsLists.ChatsLoaded[chat_group_id] = tchat;
            ++existing_chats;
        } else if (!chat_in_list) {
            CND.background.bgChatsLists.ChatsLoaded[chat_group_id] = tchat;
            ++added_new;
        }
        ++count;
    } // end foreach chats
    //console.log('unread', CND.background.totalUnreadMsgs);
    if (notifications > 0) {
        //console.log('unread chats', CND.background.bgChatsLists.UnreadChats);
        CND.background.notifications(CND.background.bgChatsLists.UnreadChats);
    }
    //console.log('count', count);
    //if (count == 0) {
    //    console.log('no chats');
    //} else if ((added_new > 0) || (existing_chats > 0)) {
    //    console.log('added', added_new, 'updated', existing_chats);
    //} // end if count
    if (!found_id && (first_id > 0)) { if (CND.background.LastActive != first_id) {
        //console.log('found_id', found_id, 'first_id', first_id, 'LastActive', CND.background.LastActive ?? null);
        CND.background.saveBackgroundChatsLocal(first_id, CND.background.bgChatsLists);
    } }
    if (CND.background.totalUnreadMsgs > 999) {
        CND.setIconBadge('999+', CND.ui.successBadgeColor);
    } else {
        CND.setIconBadge('' + CND.background.totalUnreadMsgs, CND.ui.successBadgeColor);
    }
    CND.background.bgChatsLists.ChatsLastLoaded = chats_last;
    //console.log('Going to save:NotifiedChats', CND.background.bgChatsLists.NotifiedChats ?? {});
    CND.background.saveBackgroundChatsLocal(CND.background.LastActive, CND.background.bgChatsLists);
    if (typeof callbackFunction == 'function') { setTimeout(function() { callbackFunction(); }, 1); }
}; // end function CND.background.updateChatsList


CND.background.updateMessagesList = function(msgs=[], callbackFunction=null) {
    if (CND.background.LastActive != CND.background.bgChatsLists.MessagesChatGroupId) {
        CND.background.bgChatsLists.MessagesLoaded = [];
    } // end if messages
    CND.background.bgChatsLists.MessagesChatGroupId = CND.background.LastActive;
    var msgs_last = 0;
    if (msgs.length > 0) {
        for (var i = 0; i < msgs.length; ++i) {
            var m = msgs[i] ?? {};
            //console.log('msgs[' + i + ']', m);
            var msg_id = m.message_id ?? 0;
            if (typeof m.last != 'undefined') {
                msgs_last = msg_last = parseInt(m.last);
            } // end if m.last
        } // end foreach msg
    } // end if msgs.length
    if (msgs_last > CND.background.bgChatsLists.MessagesLastLoaded) {
        CND.background.bgChatsLists.MessagesLastLoaded = msgs_last;
        CND.background.saveBackgroundChatsLocal(CND.background.LastActive, CND.background.bgChatsLists);
    } // end if msgs_last
    if (typeof callbackFunction == 'function') { setTimeout(function() { callbackFunction(); }, 1); }
}; // end function CND.background.updateMessagesList


CND.background.notificationsClickChat = function(id) {
    clearTimeout(CND.background.loadChatsListTimeout);

    var chat = CND.background.chatsLists.Notifications[id] ?? {};
    var chat_group_id = chat.chat_group_id ?? 0;
    if (chat_group_id > 0) {
        CND.background.saveChatsLocal(chat_group_id, function() {
            CND.loadPopupWindow(false, 'chat.html');
        });
    } // end if chat_group_id
}; // end function CND.background.notificationsClickChat


CND.background.loadPopupWindowSettings = function() {
    clearTimeout(CND.background.loadChatsListTimeout);

    CND.loadPopupWindow(false, 'settings.html');
}; // end function CND.background.loadPopupWindowSettings

CND.background.notificationsSent = 0;
CND.background.notifications = function(chats=[]) {
    var notificationsSent = 0;
    if (typeof chats != 'undefined') {
        for (var k in chats) {
            var c = chats[k] ?? {};
            var t = CND.background.getContacts(c.contacts ?? []);
            var preview = c.preview ?? '';
            var contacts = t.text ?? '';
            var now = Date.now();
            var options = {
                'title' : contacts,
                'message' : preview,
                'eventTime' : now
            };

            //console.log('new chat', c);
            CND.createNotification(options, function(id) {
                //console.log('chat notification shown', c);
                CND.background.bgChatsLists.Notifications[id] = c;
                var chat_group_id = c.chat_group_id ?? 0;
                //CND.background.saveBackgroundChatsLocal(chat_group_id, CND.background.bgChatsLists);
                chrome.notifications.onClicked.removeListener(CND.background.loadPopupWindowSettings);
                chrome.notifications.onButtonClicked.removeListener(CND.background.loadPopupWindowSettings);
                chrome.notifications.onClicked.addListener(CND.background.notificationsClickChat);
                chrome.notifications.onButtonClicked.addListener(CND.background.notificationsClickChat);
            });
            CND.background.bgChatsLists.NotifiedChats[k] = c;
            ++notificationsSent;
        } // end for k
    } // end if chats
    //console.log('Finished:NotifiedChats', CND.background.bgChatsLists.NotifiedChats ?? {});
    CND.background.notificationsSent += notificationsSent;
}; // end function CND.background.notifications

if (typeof CND.jQueryLoader == "undefined") {
    CND.jQueryLoader = function(successCallback, failureCallback) {
        if (typeof jQuery != 'undefined') {
            if (typeof successCallback == 'function') { setTimeout(function() { successCallback(); }, 1); }
        } else {
            CND.getScript(CND.jQuerySrc, successCallback, failureCallback);
        } // end if jQuery
    }; // end function jQueryLoader
} // end if CND.jQueryLoader


if (typeof CND.getScript == "undefined") {
    CND.getScript = function(source, successCallback, failureCallback, type) {
        var exists = document.querySelectorAll('script[src="' + source + '"]');
        if (exists.length > 0) {
            if (typeof successCallback == 'function') { setTimeout(function() { successCallback(); }, 1); }
        } else {
            var script = document.createElement('script');
            var prior = document.getElementsByTagName('script')[0];
            if (type) { script.type = type; }
             else { script.type = 'text/javascript'; }
            script.async = 1;

            script.onload = script.onreadystatechange = function( _, isAbort ) {
                if (isAbort || !script.readyState || /loaded|complete/.test(script.readyState) ) {
                    script.onload = script.onreadystatechange = null;
                    script = undefined;

                    if (!isAbort && (typeof successCallback == 'function')) { setTimeout(function() { successCallback(); }, 1); }
                     else if (isAbort && (typeof failureCallback == 'function')) { setTimeout(function() { failureCallback(); }, 1); }
                } // end if readyState
            }; // end onload

            script.src = source;
            prior.parentNode.insertBefore(script, prior);
        } // end if exists
    }; // end function getScript
} // end if CND.getScript


// Chrome CORS work around?
chrome.runtime.onMessage.addListener(
    function(url, sender, onSuccess) {
        fetch(url)
            .then(response => response.text())
            .then(responseText => onSuccess(responseText))
        return true;  // Will respond asynchronously.
    }
); // end onMessage



// Document Ready
if (typeof document != "undefined") {
    document.addEventListener("DOMContentLoaded", function() {
        if (typeof window != "undefined") {
            window.addEventListener('offline', function(e) {
                //console.log('offline now');
                CND.online = false;
            }); // end offline

            window.addEventListener('online', function(e) {
                //console.log('online now');
                if (!CND.online) { setTimeout(function() { CND.background.getChatsLocalLite(function() { CND.background.loadChatsList(); }); }, 1); }
                CND.online = true;
            }); // end online
        } // end if window

        CND.jQueryLoader(function() {
            CND.handleIsLoaded('getAccountInfo', function() {
                CND.background.handleInit(CND.background.IntervalRefreshFast);
            }); // end handleIsLoaded
        }); // end jQueryLoader
    }); // end document ready
} else {
    CND.jQueryLoader(function() {
        CND.handleIsLoaded('getAccountInfo', function() {
            CND.background.handleInit(CND.background.IntervalRefreshFast);
        }); // end handleIsLoaded
    }); // end jQueryLoader
} // end if document
