
// VOIP Awesome Click-and-Dial Extension for Google Chrome
// Menu Script
//
//  Copyright:  VOIP Awesome Inc, 2021
//  Author:     Jambu Atchison
//  @ Support:  cs@voipawesome.com
//

// Variables
if (typeof CND == 'undefined') { var CND = {}; }
if (typeof CND.menu == 'undefined') { CND.menu = {}; }
CND.online = window.navigator.onLine;



// Functions
if (typeof CND.handleIsLoaded == 'undefined') {
    CND.handleIsLoadedWait = 1;
    CND.handleIsLoadedTimeout = null;
    CND.handleIsLoaded = function(fn='', successCallback=null, failureCallback=null, maxWait=10000, type='function') {
        if (!((typeof fn == 'string') && (fn !== ''))) { return; }
        if (CND.handleIsLoadedTimeout !== null) { clearTimeout(CND.handleIsLoadedTimeout); }
        CND.handleIsLoadedTimeout = setTimeout(function() {
            if (typeof fn == type) {
                if (typeof successCallback == 'function') { setTimeout(function() { successCallback(); }, 1); }
            } else if ((typeof fn == 'string') && (typeof CND != 'undefined') && (typeof CND[fn] == type)) {
                if (typeof successCallback == 'function') { setTimeout(function() { successCallback(); }, 1); }
            } else if (CND.popup.handleIsLoadedWait < maxWait) {
                CND.handleIsLoadedWait = CND.handleIsLoadedWait + CND.handleIsLoadedWait * 3;
                CND.handleIsLoaded(fn, successCallback, failureCallback, maxWait);
            } else {
                if (typeof failureCallback == 'function') { setTimeout(function() { failureCallback(); }, 1); }
            } // end if fn
        }, CND.handleIsLoadedWait);
    }; // end function handleIsLoaded
} // end if handleIsLoaded

CND.menu.accountIsValid = function() {
    CND.ui.show('#clickndial-menu-chat');
    document.getElementById('clickndial-menu-link-chat').click();
}; // end function accountIsValid

CND.menu.accountIsNotValid = function() {
    CND.ui.hide('#clickndial-menu-chat');
    //setTimeout(function() { CND.poptastic('settings.html', 'VOIP Awesome CND', true); }, 10);
    document.getElementById('clickndial-menu-link-settings').click();
}; // end function accountIsNotValid



// Document Ready
document.addEventListener("DOMContentLoaded", function() {
    window.addEventListener('offline', function(e) { console.log('offline'); CND.online = false; });
    window.addEventListener('online', function(e) { console.log('online'); CND.online = true; });

    CND.handleIsLoaded('getAccountInfo', function() {
        CND.getAccountInfo(CND.menu.accountIsValid, CND.menu.accountIsNotValid);
    });
}); // end document ready
