
// VOIP Awesome Click-and-Dial Extension for Google Chrome
// Popup Script
//
//  Copyright:  VOIP Awesome Inc, 2021
//  Author:     Jambu Atchison
//  @ Support:  cs@voipawesome.com
//


// Variables
if (typeof CND == 'undefined') { var CND = {}; }
if (typeof CND.popup == 'undefined') { CND.popup = {}; }
CND.online = window.navigator.onLine;


// Functions
if (typeof CND.handleIsLoaded == 'undefined') {
    CND.handleIsLoadedWait = 1;
    CND.handleIsLoadedTimeout = null;
    CND.handleIsLoaded = function(fn='', successCallback=null, failureCallback=null, maxWait=10000, type='function') {
        if (!((typeof fn == 'string') && (fn !== ''))) { return; }
        if (CND.handleIsLoadedTimeout !== null) { clearTimeout(CND.handleIsLoadedTimeout); }
        CND.handleIsLoadedTimeout = setTimeout(function() {
            if (typeof fn == type) {
                if (typeof successCallback == 'function') { setTimeout(function() { successCallback(); }, 1); }
            } else if ((typeof fn == 'string') && (typeof CND != 'undefined') && (typeof CND[fn] == type)) {
                if (typeof successCallback == 'function') { setTimeout(function() { successCallback(); }, 1); }
            } else if (CND.popup.handleIsLoadedWait < maxWait) {
                CND.handleIsLoadedWait = CND.handleIsLoadedWait + CND.handleIsLoadedWait * 3;
                CND.handleIsLoaded(fn, successCallback, failureCallback, maxWait);
            } else {
                if (typeof failureCallback == 'function') { setTimeout(function() { failureCallback(); }, 1); }
            } // end if fn
        }, CND.handleIsLoadedWait);
    }; // end function handleIsLoaded
} // end if handleIsLoaded


// Document Ready
document.addEventListener("DOMContentLoaded", function() {
    window.addEventListener('offline', function(e) { console.log('offline'); CND.online = false; });
    window.addEventListener('online', function(e) { console.log('online'); CND.online = true; });

    CND.handleIsLoaded('loadPopupWindow', function() {
        console.log('CND.loadPopupWindow loaded');
        window.addEventListener("hashchange", function() {
            CND.loadPopupWindow(true);
        }); // end on hashchange
        CND.loadPopupWindow(true);
    });
}); // end document ready

